/******************************************************************************
 *
 * Copyright (c) 1994-2002 PalmSource, Inc. All rights reserved.
 *
 * File: StartupCode.c
 *
 * Release: Palm OS 5 SDK (68K) R3.
 *
 * Description:
 *		Application startup code for applications compiled using Metrowerks
 *	Tools. 
 *
 *    This module must be linked in with Pilot applications that run
 *  on the device.
 *
 *****************************************************************************/

// Include only the specific headers that we need
#include <PalmTypes.h>
#include <SystemMgr.h>
#include <ErrorBase.h>
#include <ErrorMgr.h>		// for ErrDisplay()


// this is data init code called by __startup__()
//extern  void	__InitCode__(void);				

// Our internal startup code
UInt32 __Startup__(void);


/****************************************************************/
/* Purpose..: The Startup routine for Applications		*/
/* Input....: ---						*/
/* Returns..: ---						*/
/****************************************************************/
UInt32 __Startup__(void)
{
	UInt32			result;
	void *			prevGlobalsP;
	void *			globalsP;
	Err				err;
	SysAppInfoPtr	appInfoP;
	
	
	// Call the Standary system code for allocating and initializing globals and
	//  setting up A5, and getting the command line arguments
	err = SysAppStartup(&appInfoP, &prevGlobalsP, &globalsP);
	if (err) {
		ErrDisplay("Error launching application");
		return 0;
		}
		
		
	// Call Init code provided by the compiler
//	if (appInfoP->launchFlags & sysAppLaunchFlagNewGlobals)
//		__InitCode__();


	// Call the PilotMain routine and get the result
	result = PilotMain(appInfoP->cmd, appInfoP->cmdPBP, appInfoP->launchFlags);
	
	
	// Call SysAppExit to dispose of application allocated memory chunks
	//  and delete the AMX task if this app was on it's own thread
	SysAppExit(appInfoP, prevGlobalsP, globalsP);
	
	return result;
}


